package gov.va.med.mhv.getcare.converter;

import gov.va.med.mhv.getcare.common.dto.AppointmentDTO;
import gov.va.med.mhv.getcare.model.Appointment;

import java.util.ArrayList;
import java.util.List;

public class AppointmentConverter {
	public static AppointmentDTO  convertAppointmentDomain(Appointment appointment ){
		AppointmentDTO dto = new AppointmentDTO();
		dto.setAppointmentID(appointment.getId());
		dto.setAppointmentStatus(appointment.getAppointmentStatus());
		dto.setAppointmentType(appointment.getAppointmentType());
		dto.setApptDateImprecise(appointment.getApptDateImprecise());
		dto.setApptDatePrecise(appointment.getApptDatePrecise());
		dto.setClinicName(appointment.getClinicName());
		dto.setClinicPhone(appointment.getClinicPhone());
		dto.setCurrentStatus(appointment.getCurrentStatus());
		dto.setEkgDateImprecise(appointment.getEkgDateImprecise());
		dto.setEkgDatePrecise(appointment.getEkgDatePrecise());
		dto.setFacilityInfoId(appointment.getFacilityInfoId());
		dto.setIen(appointment.getIen());
		dto.setLabDateImprecise(appointment.getLabDateImprecise());
		dto.setLabDatePrecise(appointment.getLabDatePrecise());
		dto.setLocation(appointment.getLocation());
		dto.setPatientId(appointment.getPatientId());
		dto.setPhrFacilityControlId(appointment.getPhrFacilityControlId());
		dto.setXrayDateImprecise(appointment.getXrayDateImprecise());
		dto.setXrayDatePrecise(appointment.getXrayDatePrecise());
		return dto;
	}
	
	public static Appointment convertAppointmentDTO(AppointmentDTO dto){
		Appointment appointment = new Appointment();
		appointment.setId(dto.getAppointmentID());
		appointment.setAppointmentStatus(dto.getAppointmentStatus());
		appointment.setAppointmentType(dto.getAppointmentType());
		appointment.setApptDateImprecise(dto.getApptDateImprecise());
		appointment.setApptDatePrecise(dto.getApptDatePrecise());
		appointment.setClinicName(dto.getClinicName());
		appointment.setClinicPhone(dto.getClinicPhone());
		appointment.setCurrentStatus(dto.getCurrentStatus());
		appointment.setEkgDateImprecise(dto.getEkgDateImprecise());
		appointment.setEkgDatePrecise(dto.getEkgDatePrecise());
		appointment.setFacilityInfoId(dto.getFacilityInfoId());
		appointment.setIen(dto.getIen());
		appointment.setLabDateImprecise(dto.getLabDateImprecise());
		appointment.setLabDatePrecise(dto.getLabDatePrecise());
		appointment.setLocation(dto.getLocation());
		appointment.setPatientId(dto.getPatientId());
		appointment.setPhrFacilityControlId(dto.getPhrFacilityControlId());
		appointment.setXrayDateImprecise(dto.getXrayDateImprecise());
		appointment.setXrayDatePrecise(dto.getXrayDatePrecise());
		return appointment;
	}
	
	public static List<AppointmentDTO>  convertAppoinmentRecords( List<Appointment> appointments ){
		List<AppointmentDTO> dtos = new ArrayList<AppointmentDTO>();
		for(Appointment appointment : appointments){
			AppointmentDTO dto = convertAppointmentDomain(appointment);
			dtos.add(dto);
		}
		return dtos;
	}
}
